const Member = require('../models/Member');

exports.getMembers = async (req, res) => {
    try {
        const members = await Member.findAll();
        res.json(members);
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
};

exports.createMember = async (req, res) => {
    try {
        const newMember = await Member.create(req.body);
        res.json(newMember);
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
};