const roleMiddleware = (...allowedRoles) => {
  return (req, res, next) => {
    if (!req.user.approved) {
      return res.status(403).json({ message: "User not approved yet" });
    }

    if (!allowedRoles.includes(req.user.role)) {
      return res
        .status(403)
        .json({ message: "Access denied: insufficient permissions" });
    }

    next();
  };
};

module.exports = roleMiddleware;
