// models/Prayer.js
const { DataTypes } = require("sequelize");
const sequelize = require("../config/db");

const Prayer = sequelize.define(
  "Prayer",
  {
    requestId: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    memberName: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    requestStatus: {
      type: DataTypes.STRING,
      allowNull: false,
      defaultValue: "Pending",
    },
  },
  {
    timestamps: true,
    tableName: "prayers",
  }
);

module.exports = Prayer;
