const express = require("express");
const {
  getCellGroups,
  getCellGroupById,
  createCellGroup,
  updateCellGroup,
  deleteCellGroup,
} = require("../controllers/cellGroupController");

const router = express.Router();

router.get("/", getCellGroups); // Fetch all cell groups
router.get("/:id", getCellGroupById); // Fetch a single cell group by ID
router.post("/", createCellGroup); // Create a new cell group
router.put("/:id", updateCellGroup); // Update a cell group
router.delete("/:id", deleteCellGroup); // Delete a cell group

module.exports = router;
