const { DataTypes } = require("sequelize");
const db = require("../config/db");

const CellGroup = db.define("CellGroup", {
  id: { type: DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
  group: { type: DataTypes.STRING, allowNull: false },
  description: { type: DataTypes.STRING, allowNull: false },
  leader: { type: DataTypes.STRING, allowNull: false },
  meetingDay: { type: DataTypes.STRING, allowNull: false },
  time: { type: DataTypes.STRING, allowNull: false },
  venue: { type: DataTypes.STRING, allowNull: false },
}, {
  timestamps: true,
});

module.exports = CellGroup;
