const { DataTypes } = require('sequelize');
const sequelize = require('../config/db'); // Ensure correct DB connection

const Member = sequelize.define('Member', {
    memberId: { // Matches API field
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true
    },
    name: { // Combines first_name & last_name for simplicity
        type: DataTypes.STRING,
        allowNull: false
    },
    gender: { // Stores array as JSON
        type: DataTypes.JSON, 
        allowNull: false
    },
    email: {
        type: DataTypes.STRING,
        allowNull: false,
        unique: true
    },
    mobile: { // Matches API field name
        type: DataTypes.STRING,
        allowNull: true
    },
    status: { // Matches API field name
        type: DataTypes.STRING,
        allowNull: true
    },
    createdAt: { // Sequelize default
        type: DataTypes.DATE,
        defaultValue: DataTypes.NOW
    },
    updatedAt: { // Sequelize default
        type: DataTypes.DATE,
        defaultValue: DataTypes.NOW
    }
}, {
    timestamps: true, // Enables Sequelize's automatic timestamps
    tableName: 'members'
});

module.exports = Member;
