const { DataTypes } = require('sequelize');
const sequelize = require('../config/db'); // Import Sequelize instance

const Visitor = sequelize.define('Visitor', {
    visitor_id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
      },
    id_number: {
        type: DataTypes.INTEGER,
        allowNull: false,
        unique: true, // Mark as unique, not primary
      },
    name: {
        type: DataTypes.STRING,
        allowNull: false
    },
    gender: {
        type: DataTypes.STRING,
        allowNull: false
    },
    email: {
        type: DataTypes.STRING,
        allowNull: false,
        unique: true
    },
    mobile: {
        type: DataTypes.STRING,
        allowNull: false
    },
    date_of_visit: {
        type: DataTypes.DATE,
        allowNull: false
    }
}, {
    timestamps: false,
    tableName: 'visitors'
});

module.exports = Visitor;
