const express = require("express");
const { getUsers, getUserById, createUser, updateUser, deleteUser } = require("../controllers/userController");

const router = express.Router();

// Define user-related routes
router.get("/", getUsers); // Get all users
router.get("/:id", getUserById); // Get a single user by ID
router.post("/", createUser); // Create a new user
router.put("/:id", updateUser); // Update user details
router.delete("/:id", deleteUser); // Delete a user

module.exports = router;
