const express = require('express');
const router = express.Router();
const visitorController = require('../controllers/visitorController');

router.get('/', visitorController.getVisitors); // Get all visitors
router.get('/:id', visitorController.getVisitorById); // Get visitor by ID
router.post('/', visitorController.createVisitor); // Create new visitor
router.put('/:id', visitorController.updateVisitor); // Update visitor
router.delete('/:id', visitorController.deleteVisitor); // Delete visitor

module.exports = router;
