const { PrayerRequest } = require("../models/prayerRequest"); // Sequelize model

// Get all prayer requests
const getPrayerRequests = async (req, res) => {
    try {
        const requests = await PrayerRequest.findAll();
        res.json(requests);
    } catch (error) {
        res.status(500).json({ error: "Failed to fetch prayer requests" });
    }
};

// Create a new prayer request
const createPrayerRequest = async (req, res) => {
    try {
        const { memberName, memberId, requestText, requestStatus } = req.body;
        const newRequest = await PrayerRequest.create({
            memberName,
            memberId,
            requestText,
            requestStatus
        });
        res.status(201).json(newRequest);
    } catch (error) {
        res.status(500).json({ error: "Failed to create prayer request" });
    }
};

// Update a prayer request
const updatePrayerRequest = async (req, res) => {
    try {
        const { id } = req.params;
        const { requestStatus } = req.body;

        const request = await PrayerRequest.findByPk(id);
        if (!request) return res.status(404).json({ error: "Prayer request not found" });

        await request.update({ requestStatus });
        res.json({ message: "Prayer request updated", request });
    } catch (error) {
        res.status(500).json({ error: "Failed to update prayer request" });
    }
};

// Delete a prayer request
const deletePrayerRequest = async (req, res) => {
    try {
        const { id } = req.params;
        const request = await PrayerRequest.findByPk(id);
        if (!request) return res.status(404).json({ error: "Prayer request not found" });

        await request.destroy();
        res.json({ message: "Prayer request deleted" });
    } catch (error) {
        res.status(500).json({ error: "Failed to delete prayer request" });
    }
};

module.exports = { getPrayerRequests, createPrayerRequest, updatePrayerRequest, deletePrayerRequest };
